
  /*
   *  Object %name    : %
   *  State           :  %state%
   *  Creation date   :  Mon Nov 29 18:42:53 2007
   *  Last modified   :  %modify_time%
   */
  /** @file
   *  \brief This file contains menu of the CRYS external application
   *
   *  \version CRYS_Ext_ATP_TST_menu.c#1:csrc:1
   *  \author doronp
   *  \remarks Copyright (C) 2007 by Discretix Technologies Ltd.
   *           All Rights reserved
   */

/* disabling pc lint warning regarding to constant condition :
   'Constant value Boolean' */
/*lint --e{506} */
/*lint --e(553) */
/*lint --e(713) */
/***** Include Files **************/


#include "CRYS.h"
#include "MW_ATP_UTIL_funcs.h"
#include "CRYS_Ext_ATP_TST_Defines.h"
#include "CRYS_ATP_TST_UTIL_Funcs.h"
#include "DX_ConnectivityTest.h"
#include "CRYS_SELF_TEST.h"
#include "DX_VOS_Mem.h"
#include "DX_VOS_File.h"
#include "DX_VOS_Stdio.h"

/******** Defines ************/
#if TST_ENABLE_PERFORMANCE_TST
DxUint32_t      TST_Timer = 1;
DxUint32_t      TST_PerformanceDataSize;
float           TST_PerformanceMasure;
#endif

/*AES*/
extern CRYSError_t CRYS_ExtApp_ATP_AES_Acceptance_ALL_TESTS(void);

/*DES*/
extern CRYSError_t CRYS_ExtApp_ATP_DES_Acceptance_ALL_TESTS(void);

/* HASH */
extern CRYSError_t CRYS_ExtApp_ATP_HASH_Acceptance_ALL_TESTS(void);

/*HMAC*/
#if TST_USE_HMAC_DATA
extern CRYSError_t CRYS_ExtApp_ATP_HMAC_Acceptance_ALL_TESTS(void);
#endif

/*RSA*/
#if TST_USE_RSA_DATA
extern CRYSError_t CRYS_ExtApp_ATP_RSA_Acceptance_ALL_TESTS(int TST_KeyGeneration_TestStatus);
#endif

/*DH*/
#if TST_USE_DH_DATA
extern CRYSError_t CRYS_ExtApp_ATP_DH_Acceptance_ALL_TESTS(void);
#endif

/* RND */
#if TST_USE_RND_DATA
extern CRYSError_t CRYS_ExtApp_ATP_RND_Acceptance_ALL_TESTS(void);
#endif

/*ECC*/
#if TST_USE_ECC_DATA
extern CRYSError_t CRYS_ExtApp_ATP_ECC_Acceptance_ALL_TESTS(int TST_KeyGeneration_TestStatus);
#endif

/*RC4*/
#if TST_USE_RC4_DATA
extern CRYSError_t CRYS_ExtApp_ATP_RC4_Acceptance_ALL_TESTS(void);
#endif

/******** Enums ************/
/******** Typedefs ***********/
/******** Global Data **********/
extern CRYS_Version_t  TST_ATP_CRYS_version;

/******** Public Functions *****/

/***************************
 * Function Name:
 *  CRYS_ATP_TST_RunAllAcceptance_tests
 *
 * Inputs:
 * 	TST_KeyGeneration_TestStatus - A parameter defining if to run the test with internal key generation
 *                                TST_INTERNAL_KG - Run the test with internal key generation and external keys
 *                                TST_EXTERNAL_KEYPAIR  - Run the test with external key only - NO keyGen
 *
 * Outputs:
 *  DxError_t - Function error return
 *
 * Description:
 * This function runs all of the Acceptance tests
 *
 **************************/
DxError_t CRYS_Ext_ATP_TST_RunAllAcceptance_tests(DxUint32_t TST_KeyGeneration_TestStatus)
{
    CRYSError_t TST_Error_ATP = TESTPASS;

#ifndef CRYS_NO_AES_SUPPORT
    /*AES*/
    TST_ATP_Error = CRYS_ExtApp_ATP_AES_Acceptance_ALL_TESTS();
    TST_Error_ATP = TST_Error_ATP+TST_ATP_Error;
#endif

#ifndef CRYS_NO_DES_SUPPORT
    /*DES*/
    TST_ATP_Error = CRYS_ExtApp_ATP_DES_Acceptance_ALL_TESTS();
    TST_Error_ATP = TST_Error_ATP+TST_ATP_Error;
#endif

#ifndef CRYS_NO_RC4_SUPPORT
    /*RC4*/
    #if TST_USE_RC4_DATA
    TST_ATP_Error = CRYS_ExtApp_ATP_RC4_Acceptance_ALL_TESTS();
    TST_Error_ATP = TST_Error_ATP+TST_ATP_Error;
    #endif
#endif


#ifndef CRYS_NO_HASH_SUPPORT
    /*HASH*/
    TST_ATP_Error = CRYS_ExtApp_ATP_HASH_Acceptance_ALL_TESTS();
    TST_Error_ATP = TST_Error_ATP+TST_ATP_Error;
    
    /*HMAC*/
    #if TST_USE_HMAC_DATA
    TST_ATP_Error = CRYS_ExtApp_ATP_HMAC_Acceptance_ALL_TESTS();
    TST_Error_ATP = TST_Error_ATP+TST_ATP_Error;
    #endif
    #ifndef CRYS_NO_PKI_SUPPORT
    /*RSA*/
    #if TST_USE_RSA_DATA
    TST_ATP_Error = CRYS_ExtApp_ATP_RSA_Acceptance_ALL_TESTS(TST_KeyGeneration_TestStatus);
    TST_Error_ATP = TST_Error_ATP+TST_ATP_Error;
    #endif
    #endif
    
#endif


#ifndef CRYS_NO_ECPKI_SUPPORT
    #if TST_USE_ECC_DATA
    TST_ATP_Error = CRYS_ExtApp_ATP_ECC_Acceptance_ALL_TESTS(TST_KeyGeneration_TestStatus);
    TST_Error_ATP = TST_Error_ATP+TST_ATP_Error;
    #endif
#endif

#if TST_USE_RND_DATA
   	TST_ATP_Error = CRYS_ExtApp_ATP_RND_Acceptance_ALL_TESTS();
    TST_Error_ATP = TST_Error_ATP+TST_ATP_Error;	  	        			      
#endif

 #if TST_USE_DH_DATA
    TST_ATP_Error = CRYS_ExtApp_ATP_DH_Acceptance_ALL_TESTS();
    TST_Error_ATP = TST_Error_ATP+TST_ATP_Error;
 #endif


    /*Check if all tests pass*/
    if (TST_Error_ATP != TESTPASS)
        {
            ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n\n!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!\n"));
            ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"!!!!!!!!! ONE OR MORE OF THE EXTERNAL APP ATP TESTS FAILED !!!!!!!!!!!!!!!!!!!!\n"));
            ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!\n"));
        }
        else
        {
            ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n \n**********************\n"));
            ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"* ATP  ATP  ATP  ATP  ATP  ATP  ATP  ATP  ATP  ATP  ATP  ATP ***\n"));
            ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"**********************\n"));
            ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"*** ALL OF THE EXTERNAL APP ATP  TESTS PASS     :-)         *****\n"));
            ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"**********************\n"));
            ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"* ATP  ATP  ATP  ATP  ATP  ATP  ATP  ATP  ATP  ATP  ATP  ATP ***\n"));
            ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"**********************\n"));
        }
    return TST_Error_ATP;
}

/***************************
 * Function Name:
 *  CRYS_ATP_menu
 *
 * Inputs:
 * 	none
 *
 * Outputs:
 *  DxError_t - Function error return
 *
 * Description:
 * This function displays and dispatches CRYS ATP tests
 *
 **************************/
DxError_t CRYS_ExtApp_ATP_menu(void)
 {
    /* Get CRYS Version */
    CRYS_GetVersion(&TST_ATP_CRYS_version);

    if (TST_IsInteractive == 1)
    {
       CRYS_ATP_TST_RunAllAcceptance_tests(TST_UseInternalKG);
    }
    else
    {
        DxUint8_t  Var;

        do
        {
	        do
	        {
			        ATP_LOG_TST_PRINT((MW_ATP_MSG,"\n\n\n           -- DISCRETIX LTD 2007 --              "));
	                ATP_LOG_TST_PRINT((MW_ATP_MSG,"\n       -- Acceptance tests Ver -  06.03.00 --        "));
                    ATP_LOG_TST_PRINT((MW_ATP_MSG,"\n-----------------------------------------------------"));
	                ATP_LOG_TST_PRINT((MW_ATP_MSG,"\n---[ Main Tests Menu ]-------------------------------"));
                    ATP_LOG_TST_PRINT((MW_ATP_MSG,"\n-----------------------------------------------------"));
                    ATP_LOG_TST_PRINT((MW_ATP_MSG,"\n [0] - Get CRYS Version                              "));
	                ATP_LOG_TST_PRINT((MW_ATP_MSG,"\n-----------------------------------------------------"));
	                ATP_LOG_TST_PRINT((MW_ATP_MSG,"\n [1] - Connectivity test                              "));
	                ATP_LOG_TST_PRINT((MW_ATP_MSG,"\n-----------------------------------------------------"));
                    #ifndef CRYS_NO_AES_SUPPORT
                    
	                ATP_LOG_TST_PRINT((MW_ATP_MSG,"\n [2] - AES            Tests                          "));
                    
                    #endif
                    #ifndef CRYS_NO_DES_SUPPORT
                    
	                ATP_LOG_TST_PRINT((MW_ATP_MSG,"\n [3] - DES/3DES       Tests                          "));
                    
                    #endif
                    #ifndef CRYS_NO_HASH_SUPPORT
                    
	                ATP_LOG_TST_PRINT((MW_ATP_MSG,"\n [4] - HASH           Tests                          "));
	                #endif
                    
                    #if TST_USE_HMAC_DATA
	                ATP_LOG_TST_PRINT((MW_ATP_MSG,"\n [5] - HMAC           Tests                          "));
                    #endif
                        #ifndef CRYS_NO_PKI_SUPPORT
                    #if TST_USE_RSA_DATA
	                ATP_LOG_TST_PRINT((MW_ATP_MSG,"\n [6] - RSA            Tests                          "));
                    #endif
                    
                        #endif
                        
                        #ifndef CRYS_NO_ECPKI_SUPPORT
                    #if TST_USE_ECC_DATA
                    ATP_LOG_TST_PRINT((MW_ATP_MSG,"\n [7] - ECC            Tests                          "));
                    #endif
                    
                        #endif
                        
                    #if TST_USE_RND_DATA
	                ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n [8] - RND            Tests                          "));
                    #endif    
                                    
                    #if TST_USE_DH_DATA
	                ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n [9] - DH             Tests                          "));
                    #endif   
                                      
                    #ifndef CRYS_NO_RC4_SUPPORT
                    
	                ATP_LOG_TST_PRINT((MW_ATP_MSG,"\n [A] - RC4            Tests                          "));
                    
                    #endif
					
                    
                   
	                ATP_LOG_TST_PRINT((MW_ATP_MSG,"\n-----------------------------------------------------"));
	                
                    #if TST_USE_TEST_DATA
	                ATP_LOG_TST_PRINT((MW_ATP_MSG,"\n [T] - Run all Acceptance Tests "));
	                ATP_LOG_TST_PRINT((MW_ATP_MSG,"\n       [with internal KeyGeneration for RSA & ECC]   "));
	                ATP_LOG_TST_PRINT((MW_ATP_MSG,"\n-----------------------------------------------------"));
	                ATP_LOG_TST_PRINT((MW_ATP_MSG,"\n [S] - Run all Acceptance Tests                      "));
                    ATP_LOG_TST_PRINT((MW_ATP_MSG,"\n       [without internal KeyGeneration for RSA & ECC]"));
                    #endif
	                ATP_LOG_TST_PRINT((MW_ATP_MSG,"\n [Z] - End of tests                                  "));
	                ATP_LOG_TST_PRINT((MW_ATP_MSG,"\n-------------------------------------------------\n\n"));
	                GET_NON_WHITE_SPACE_CHAR(Var);
	                ATP_LOG_TST_PRINT((MW_ATP_MSG,"\n Test = %c\n",Var));
	                if (Var<='Z')
	                            break;
	                else
	                {
	                        ATP_LOG_TST_PRINT((MW_ATP_MSG,"\n Error[%d]  Please select '1'-'XX'\n\n",Var));
	                }

	            }while(1);


	            switch(Var)
	            {

                    case '0':
				            CRYS_ATP_TST_ShowCRYSVersion();
				            break;
	                case '1': 
	                        DxConnectivityTest();
	                        break;
	                        
                    #ifndef CRYS_NO_AES_SUPPORT
		  	        case '2':
				            CRYS_ExtApp_ATP_AES_main();
				            break;
                    
                    #endif
                    
                    #ifndef CRYS_NO_DES_SUPPORT
		  	        case '3':
				            CRYS_ExtApp_ATP_DES_main();
				            break;
                    #endif
                    
                    #ifndef CRYS_NO_HASH_SUPPORT
                    case '4':
				            CRYS_ExtApp_ATP_HASH_main();
				            break;
                    #endif
                    
                    #if TST_USE_HMAC_DATA
   		  	        case '5':
				            CRYS_ExtApp_ATP_HMAC_main();
				            break;
                    #endif
                        #ifndef CRYS_NO_PKI_SUPPORT

   		  	        #if TST_USE_RSA_DATA
                    case '6':   
				             CRYS_ExtApp_ATP_RSA_main();
                            break;
                    #endif
                    #endif
                    
                    #ifndef CRYS_NO_ECPKI_SUPPORT
                    #if TST_USE_ECC_DATA
                    case '7':   
				             CRYS_ExtApp_ATP_ECC_main();
                            break;
                    #endif
                    #endif
                    
                    #if TST_USE_RND_DATA
   		  	        case '8':
				            CRYS_ExtApp_ATP_RND_main();
				            break;
                    #endif
                    
                    #if TST_USE_DH_DATA
   		  	        case '9':
				            CRYS_ExtApp_ATP_DH_main();
				            break;
                    #endif
                    
                    #ifndef CRYS_NO_RC4_SUPPORT
                    
   		  	        case 'A':
				            CRYS_ExtApp_ATP_RC4_main();
				            break;
                    
                    #endif
					
                    				            
					case 'T':
				            CRYS_Ext_ATP_TST_RunAllAcceptance_tests(TST_INTERNAL_KG);
				            break;
   		  	        case 'S':
				            CRYS_Ext_ATP_TST_RunAllAcceptance_tests(TST_EXTERNAL_KEYPAIR);
				            break;
	       	        case 'Z':
	                        DX_VOS_Printf("\n End of CRYS tests \n");
	                        break ;
	       	        default:
	                    ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n* Error in test selection [%c]\n",Var));
	            }
	            if(Var =='Z')
	            break;
            }while (1);
        return 0;
    }
    return 0;
 }/* End of CRYS_Ext_ATP_menu */

